/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// Dream Catcher by eiffie (random experiments in 2.5d tracing)
// A bunch of hackery to add some 3d-ness. Move the cam too much and it disappears.

//#define THIS_IS_BORING_HOW_ABOUT_A_SPIRAL_DRAWN_FROM_A_SINGLE_SPHERE
//#define OR_A_CRAZY_PATTERN

#define size iResolution
#define time iGlobalTime

vec3 ro, rd, L;
vec4 clr=vec4(0.0);
float ct=100.0;
vec3 getColor(float id){
	vec3 col=vec3(0.6,0.6,0.3);
	if(id<0.5)col=vec3(0.7,0.6,0.5);
	else if(id<1.5)col=vec3(0.3,1.0,0.6);
	return col;
}
void Sphere(vec3 p, float r, float id){//modified from iq's
	p-=ro;
	float b=dot(p,rd);
	float h=b*b-dot(p,p)+r*r;
	if(h>0.0){
		float t=b-sqrt(h);
		h=smoothstep(0.0,0.005,h);//now alpha
		if(t<ct || h>clr.a){//if closer or higher alpha
			vec3 N=normalize(rd*t-p);
			vec3 col=getColor(id)*max(0.0,dot(N,L))+vec3(-0.25,0.0,0.0)*dot(N,rd);
			col+=vec3(1.0,0.5,0.0)*pow(max(0.0,dot(reflect(rd,N),L)),8.0);
			if(t<ct){
				ct=t;
				clr.rgb=mix(clr.rgb,col,h);
			}else{//h>w
				clr.rgb=mix(clr.rgb,col,h-clr.a);
			}
			clr.a=max(clr.a,h);
		}
	}
}
#ifdef OR_A_CRAZY_PATTERN
vec2 sm(vec2 p){
	vec2 g=floor(p+0.5);
	vec2 g1=g+sin(g.yx*6.2832*fract(time)+g*6.2832*(1.0-fract(time*1.3)))*0.25;
	vec2 g2=g+vec2(1.0*sign(p.x-g1.x),0.0);
	g2+=sin(g2.yx*6.2832*fract(time)+g2*6.2832*(1.0-fract(time*1.3)))*0.25;
	vec2 gD=g2-g1;
	float t=clamp(dot(p-g1,gD)/dot(gD,gD),0.0,1.0);
	return mix(g1,g2,t+sin(t*31.416)*0.05);
}
#endif
mat3 lookat(vec3 fw,vec3 up){
	fw=normalize(fw);vec3 rt=normalize(cross(fw,up));return mat3(rt,cross(rt,fw),fw);
}

void main( void )
{
	float tim=time;
	ro=vec3(cos(tim*2.1),sin(tim*1.4),sin(tim*0.3))*0.025;ro.z-=3.0;
	mat3 rotCam=lookat(vec3(sin(time*0.9)*0.05,sin(tim*1.4)*0.1,1.0),vec3(0.0,1.0,0.0));
	rd=rotCam*normalize(vec3((size.xy-2.0*gl_FragCoord.xy)/size.y,1.75));
	L=normalize(vec3(0.1,-0.6,-0.2));
	float t=-ro.z/rd.z;
	vec3 s=ro+rd*t;
	float a=atan(s.y,s.x);
#ifdef THIS_IS_BORING_HOW_ABOUT_A_SPIRAL_DRAWN_FROM_A_SINGLE_SPHERE
	float r=floor(4.0*pow(dot(s.xy,s.xy),0.25)-a/6.283-fract(tim))+1.0+fract(tim)+a/6.283;
	vec3 p=vec3(cos(a),sin(a),0.0)*r*r*0.0625;p.z=0.5;
	Sphere(p,r*0.025,0.0);
	float b=abs(mod(a,0.62832)-0.31416);
	p=vec3(cos(a),sin(a),0.0)*(1.0+sin(b*10.0)*0.1);
	Sphere(p,0.06,1.0);
	p=vec3(cos(a),sin(a),0.0)*(1.0-sqrt(b)*0.66);
	Sphere(p,0.06,1.0);
#elif defined OR_A_CRAZY_PATTERN
	vec2 u=sm(s.xy);
	Sphere(vec3(u,0.0),0.1,0.0);
	//s=ro+rd*(-0.25-ro.z/rd.z);
	u=sm(s.yx);
	Sphere(vec3(u.yx,0.0),0.1,1.0);
#else	
	vec3 p=vec3(cos(a),sin(a),0.0);
	Sphere(p,0.125,0.0);
	p*=2.0;
	Sphere(p,0.125,1.0);
	float b=2.0;
#define A 1.86642
	mat2 mx=mat2(cos(A),-sin(A),sin(A),cos(A));
	for(int i=0;i<10;i++){
		rd.xy=mx*rd.xy;
		L.xy=L.xy*mx;  
		s=ro+rd*t;
		float t2=t+sin(s.x*b)*0.25;
		s=ro+rd*t2;
		p=vec3(s.x,sin(s.x)*0.25+0.25,sin(s.x*b)*0.25)+vec3(sin(s.x*100.0))*0.005;
		Sphere(p,0.1,2.0);
	}
#endif	
	vec3 col=mix(vec3(1.0),clr.rgb,clr.a);
	
	gl_FragColor = vec4(col,1.0);

}
